package gov.va.med.mhv.admin.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CommonUtility {
	//private static Logger log = LogManager.getLogger(CommonUtility.class);
	
	public static String dateToString (Date date,String format){
		String stringDate=null;
		try{
			if(date != null){
			   SimpleDateFormat sdf = new SimpleDateFormat(format);
			   stringDate =sdf.format(date);
			}
		}catch(Exception ex){
			throw new RuntimeException("Invalid Date format" + ex);
		}
		return stringDate;
	}
	
	public static String dateToStringTimeZone (Date date,String format){
		String stringDate="";
		try{
			if(date != null){
			   SimpleDateFormat sdf = new SimpleDateFormat(format);
			   sdf.setTimeZone(TimeZone.getTimeZone("America/New_York"));
			   stringDate =sdf.format(date);
			}
		}catch(Exception ex){
			throw new RuntimeException("Invalid Date format" + ex);
		}
		return stringDate;
	}
	
	public static Date getDaTeTime(Date date,String hour, String minute){
		
		Integer intHour=0;
		Integer intMinute=0;
		if(hour != null){
		   intHour = Integer.parseInt(hour);	
		}
		if(minute != null){
		   intMinute = Integer.parseInt(minute);
		}
		Calendar cal =Calendar.getInstance();
		String str_date=dateToString(date,"MM/dd/yyyy");
		Date cal_date = stringToDate(str_date,"MM/dd/yyyy");
		cal.setTime(cal_date);
		cal.set(Calendar.HOUR_OF_DAY,intHour);
		cal.set(Calendar.MINUTE,intMinute);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND,0);
		
		
		return cal.getTime();
	}
	
	public static int dateToInt (Date date,String format){
		int intDate=0;
		try{
			if(date != null){
			   SimpleDateFormat sdf = new SimpleDateFormat(format);
			   intDate =Integer.parseInt(sdf.format(date));
			}
		}catch(Exception ex){
			throw new RuntimeException("Invalid Date format" + ex);
		}
		return intDate;
	}
	
	public static Date stringToDate(String dateStr,String format) {
		Date date=null;
		try{
			SimpleDateFormat sdf = new SimpleDateFormat(format);
			date= sdf.parse(dateStr);
		}catch(Exception ex){
			throw new RuntimeException("Invalid Date format" + ex);
		}
		return date;
	}

}
